<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package GreatMag
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<section class="error-404 not-found">

				<div class="notice-404">404</div>

				<header class="page-header">
					<h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'greatmag' ); ?></h1>
				</header><!-- .page-header -->

				<div class="page-content">
					<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe go back home or see the latest posts below.', 'greatmag' ); ?></p>

					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="btn back-to-page"><?php esc_html_e( 'Back home', 'greatmag'); ?></a>

					<?php
						the_widget( 'Athemes_Posts_Carousel' );
					?>

				</div><!-- .page-content -->
			</section><!-- .error-404 -->

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();
