<?php
/*
Plugin Name: Soundwave Post Type
Plugin URL: http://wizedesign.com/
Description: With the help of this plugin you can create different types of posts like slider, event, audio, mix, photo, video, artist, review and location.
Version: 1.0
Author: wizedesign
Author URI: http://wizedesign.com/
*/

//===================================================wizedesign==
//  CONSTANTS
//===============================================================

if (!defined('soundwave_BASE_FILE'))
    define('soundwave_BASE_FILE', __FILE__);
if (!defined('soundwave_BASE_DIR'))
    define('soundwave_BASE_DIR', dirname(soundwave_BASE_FILE));
if (!defined('soundwave_PLUGIN_URL'))
    define('soundwave_PLUGIN_URL', plugin_dir_url(__FILE__));

include('includes/post/slider.php');
include('includes/post/event.php');
include('includes/post/audio.php');
include('includes/post/mix.php');
include('includes/post/photo.php');
include('includes/post/video.php');
include('includes/post/artist.php');

//===================================================wizedesign==
//  EVENT FILTERS
//===============================================================

add_filter('template_include', 'soundwave_template_event');

function soundwave_template_event($template) {
    
    $post_id = get_the_ID();
    
    if (get_post_type($post_id) != 'event') {
        return $template;
    }
    
    if (is_single()) {
        return soundwave_get_template_event('event');
    }
}

function soundwave_get_template_event($template) {
    
    $template_slug = rtrim($template, '.php');
    $template      = $template_slug . '.php';
    
    if ($theme_file = locate_template(array(
        'plugin_template/' . $template
    ))) {
        $file = $theme_file;
    } else {
        $file = soundwave_BASE_DIR . '/includes/templates/' . $template;
    }
    
    return apply_filters('template_' . $template, $file);
}

//===================================================wizedesign==
//  AUDIO FILTERS
//===============================================================

add_filter('template_include', 'soundwave_template_audio');

function soundwave_template_audio($template) {
    
    $post_id = get_the_ID();
    
    if (get_post_type($post_id) != 'audio') {
        return $template;
    }
    
    if (is_single()) {
        return soundwave_get_template_audio('audio');
    }
}

function soundwave_get_template_audio($template) {
    
    $template_slug = rtrim($template, '.php');
    $template      = $template_slug . '.php';
    
    if ($theme_file = locate_template(array(
        'plugin_template/' . $template
    ))) {
        $file = $theme_file;
    } else {
        $file = soundwave_BASE_DIR . '/includes/templates/' . $template;
    }
    
    return apply_filters('template_' . $template, $file);
}

//===================================================wizedesign==
//  PHOTO FILTERS
//===============================================================

add_filter('template_include', 'soundwave_template_photo');

function soundwave_template_photo($template) {
    
    $post_id = get_the_ID();
    
    if (get_post_type($post_id) != 'photo') {
        return $template;
    }
    
    if (is_single()) {
        return soundwave_get_template_photo('photo');
    }
}

function soundwave_get_template_photo($template) {
    
    $template_slug = rtrim($template, '.php');
    $template      = $template_slug . '.php';
    
    if ($theme_file = locate_template(array(
        'plugin_template/' . $template
    ))) {
        $file = $theme_file;
    } else {
        $file = soundwave_BASE_DIR . '/includes/templates/' . $template;
    }
    
    return apply_filters('template_' . $template, $file);
}

//===================================================wizedesign==
//  ARTIST FILTERS
//===============================================================

add_filter('template_include', 'soundwave_template_artist');

function soundwave_template_artist($template) {
    
    $post_id = get_the_ID();
    
    if (get_post_type($post_id) != 'artist') {
        return $template;
    }
    
    if (is_single()) {
        return soundwave_get_template_artist('artist');
    }
}

function soundwave_get_template_artist($template) {
    
    $template_slug = rtrim($template, '.php');
    $template      = $template_slug . '.php';
    
    if ($theme_file = locate_template(array(
        'plugin_template/' . $template
    ))) {
        $file = $theme_file;
    } else {
        $file = soundwave_BASE_DIR . '/includes/templates/' . $template;
    }
    
    return apply_filters('template_' . $template, $file);
}